﻿var phoneTemplates = {
    context: $(".v-phoneTemplates"),
    datatable: null,
    treeview: null,
    getSelectedPhoneTemplateId: function () {
        var phoneTemplate = phoneTemplates.treeview.a4listview("getHighlightedNode");
        return phoneTemplate ? (phoneTemplate.Id || 0) : 0;
    },
    initializeDataTable: function (phoneTemplate) {
        this.datatable = $(".h-phoneTemplatesTable", phoneTemplates.context).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetPhoneTemplateRules", "MultiMode", "Settings"),
            ajaxParams: { "phoneTemplateId": phoneTemplate ? phoneTemplate.Id : 0 },
            columns: [
                { "Title": resources.Id, "Data": "Id", "Visible": false, "HideInSelector": true, "Sortable": false, "Key": true },
                { "Title": resources.RuleList, "Data": "Name", "HideInSelector": true, "Sortable": false },
                { "Title": resources.Action, "Data": "Action", "Sortable": false },
                { "Title": resources.PhoneNumberLength, "Data": "Length", "Sortable": false }
            ],
            stateKey: "PhoneTemplateRules",
            allowRowSelection: function (data) { return data.Name != 'Default' && voxco.security.has('MODIFY', data.Permissions); },
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuItems: [
                {
                    "Action": "up", "Label": resources.Up,
                    "DisplayCondition": function (data) { return data.Id > 0 && data.Name != 'Default' && voxco.security.has('MODIFY', data.Permissions); }
                },
                {
                    "Action": "down", "Label": resources.Down,
                    "DisplayCondition": function (data) { return !data.LastRule && data.Name != 'Default' && voxco.security.has('MODIFY', data.Permissions); }
                },
                { "Divider": true },
                {
                    "Action": "delete", "Label": resources.Delete,
                    "DisplayCondition": function (data) { return data.Name != 'Default' && voxco.security.has('MODIFY', data.Permissions); }
                },
                {
                    "Action": "properties", "Label": resources.Properties,
                    "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions); }
                }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                var row = data.row;
                var action = data.action;

                var selectedPhoneTemplate = $(".h-phoneTemplates").a4listview("getHighlightedNode");

                if (selectedPhoneTemplate) {
                    switch (action) {
                        case "up":
                            phoneTemplates.movePhoneTemplateRule(row.Id, "MovePhoneTemplateRuleUp");
                            break;
                        case "down":
                            phoneTemplates.movePhoneTemplateRule(row.Id, "MovePhoneTemplateRuleDown");
                            break;
                        case "delete":
                            phoneTemplates.deletePhoneTemplateRule([row.Id]);
                            break;
                        case "properties":
                            modalDialog.showWindow(a4.getAction("EditPhoneTemplateRule", "MultiMode", "Settings", { id: row.Id, phoneTemplateId: selectedPhoneTemplate.Id }), 600, 700, { afterClose: function () { phoneTemplates.refreshContent(); } });
                            break;
                    }
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    phoneTemplates.deletePhoneTemplateRule(ids);
                }
            },
            localizableTexts: { "Search": resources.SearchRules }
        });
    },
    initializeTreeView: function () {
        this.treeview = $(".h-phoneTemplates", phoneTemplates.context).a4listview({
            ajaxAction: a4.getAction("GetPhoneTemplates", "MultiMode", "Settings"),
            icons: null,
            highlightFirstNode: true,
            draw: function (event, data) {
                var phoneTemplate = data.selectedNode;

                if (phoneTemplate) {
                    if (phoneTemplates.datatable) {
                        phoneTemplates.datatable.a4datatable("option", "ajaxParams", { "phoneTemplateId": phoneTemplate ? phoneTemplate.Id : 0 });
                        phoneTemplates.datatable.a4datatable("refresh");
                    }
                    else {
                        phoneTemplates.initializeDataTable(phoneTemplate);
                    }

                    var canModify = voxco.security.has('MODIFY', phoneTemplate.Permissions);
                }
                
                $(".h-actionPhoneTemplateImportRule", phoneTemplates.context).toggleClass("hidden", !canModify);
                $(".h-newPhoneTemplateMenu .h-newPhoneTemplateRule", phoneTemplates.context).toggleClass("hidden", !canModify);
                                
                $(".h-newPhoneTemplateMenu", phoneTemplates.context).toggle($(".h-newPhoneTemplateMenu li:not(.hidden)", phoneTemplates.context).length > 0);
            },
            selectNode: function (event, data) {
                phoneTemplates.datatable.a4datatable("option", "ajaxParams", { "phoneTemplateId": data.node.Id });
                phoneTemplates.datatable.a4datatable("refresh", true);

                var canModify = voxco.security.has('MODIFY', data.node.Permissions);

                $(".h-actionPhoneTemplateImportRule", phoneTemplates.context).toggleClass("hidden", !canModify);
                $(".h-newPhoneTemplateMenu .h-newPhoneTemplateRule", phoneTemplates.context).toggleClass("hidden", !canModify);
                $(".h-newPhoneTemplateMenu", phoneTemplates.context).toggle($(".h-newPhoneTemplateMenu li:not(.hidden)", phoneTemplates.context).length > 0);
            },
            actionButtons: [
                { Action: "properties", Label: resources.Properties, Icon: "edit", DisplayCondition: function (data) { return voxco.security.has('READ', data.Permissions); } },
                { Action: "test", Label: resources.Test, Icon: "phone" },
                { Action: "delete", Label: resources.Delete, Icon: "remove", DisplayCondition: function (data) { return voxco.security.has('DELETE', data.Permissions); } }
            ],
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "test":
                        modalDialog.showWindow(a4.getAction("PhoneTemplateTest", "MultiMode", "Settings", { id: node.Id, name: node.Name }), 550, 600);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("PhoneTemplateProperties", "MultiMode", "Settings", { id: node.Id }), 600, 650, { afterClose: function () { phoneTemplates.refreshContent(); } });
                        break;
                    case "delete":
                        phoneTemplates.deletePhoneTemplate(node.Id);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchPhoneTemplates }
        });
    },
    bindEvents: function () {
        $(".h-newPhoneTemplateMenu").on("click", "li.h-newPhoneTemplate", function () {
            modalDialog.showWindow(a4.getAction("PhoneTemplateProperties", "MultiMode", "Settings"), 600, 650, {
                beforeClose: function () {
                    phoneTemplates.refreshContent();
                }
            });
        });

        $(".h-newPhoneTemplateMenu").on("click", "li.h-newPhoneTemplateRule", function () {
            var selectedPhoneTemplate = $(".h-phoneTemplates").a4listview("getHighlightedNode");

            if (selectedPhoneTemplate) {
                modalDialog.showWindow(a4.getAction("EditPhoneTemplateRule", "MultiMode", "Settings", { id: -1, phoneTemplateId: selectedPhoneTemplate.Id }), 600, 700, { afterClose: function () { phoneTemplates.refreshContent(); } });
            }
        });

        $(".h-actionPhoneTemplateImportRule").on("click", function () {
            modalDialog.showWindow(a4.getAction("ImportPhoneTemplateRule", "MultiMode", "Settings", { phoneTemplateId: phoneTemplates.getSelectedPhoneTemplateId() }), 300, 650, { afterClose: function () { phoneTemplates.refreshContent(); } });
        });

    },
    deletePhoneTemplate: function (id) {
        modalDialog.showConfirmDelete(confirmDeletePhoneTemplateResources, function () {
            a4.callServerMethod(a4.getAction("DeletePhoneTemplate", "MultiMode", "Settings"), { id: id },
                function (result) {
                    phoneTemplates.refreshContent();
                    phoneTemplates.datatable.a4datatable("option", "ajaxParams", { "phoneTemplateId": 0 });
                    phoneTemplates.datatable.a4datatable("refresh");
                    phoneTemplates.manageToolbarItemsVisibility(false);
                });
        }, 1);
    },
    deletePhoneTemplateRule: function (ids) {
        modalDialog.showConfirmDelete(confirmDeletePhoneTemplateRuleResources, function () {
            a4.callServerMethod(a4.getAction("DeletePhoneTemplateRules", "MultiMode", "Settings"), { phoneTemplateId: phoneTemplates.getSelectedPhoneTemplateId(), ids: ids },
                function (result) {
                    phoneTemplates.refreshContent();
                });
        }, ids.length);
    },
    movePhoneTemplateRule: function (id, method) {
        a4.callServerMethod(a4.getAction(method, "MultiMode", "Settings"), { phoneTemplateId: phoneTemplates.getSelectedPhoneTemplateId(), id: id }, function (result) { phoneTemplates.refreshContent(); });
    },
    refreshContent: function () {
        phoneTemplates.treeview.a4listview("refresh");
    },
    manageToolbarItemsVisibility: function (isVisible) {
        $(".h-actionPhoneTemplateImportRule", phoneTemplates.context).toggleClass("hidden", !isVisible);
    }
};

$(document).ready(function () {
    if (phoneTemplates.context.length > 0) {
        phoneTemplates.initializeTreeView();
        phoneTemplates.bindEvents();
    }
});